'==========================================================================

' NAME: Install_IIS.vbs
'

' COMMENT: This script file is used to install IIS 6.0 with the
'			components specified in the answer file used.
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'==========================================================================


Public Function InstallWebComponents(strAnswerFile)
'=========================================================================
'	NAME: InstallWebComponents
'	IN:		strAnswerFile - path to unattended answer file
'	OUT:	return code
'	COMMENT: This routine simply creates a commend line to run
'			sysocmgr.exe to run an unattended install of IIS.
'========================================================================
	Dim SetupType
	Dim nReturn
		
	
	'Create the command line
	strCmd = "cmd.exe /c sysocmgr /i:%windir%\inf\sysoc.inf /u:" & strAnswerFile
	
	'Run the command
	WshShell.Run strCmd,1,True
	nReturn = 0
	InstallWebComponents = nReturn

End Function

Public Sub StopDefaultFTP()
'===================================================
'	NAME:	StopDefaultFTP
'	IN:		None
'	COMMENT: Uses IISFtp.vbs to stop the default FTP site
'===================================================
	Dim strCmd
	Dim oExec
	'Create the commandline 
	strCmd = "cmd.exe /C cscript //nologo %systemroot%\system32\IIsFtp.vbs /stop " & chr(34) & "Default Ftp Site" & Chr(34)
	'execute it
	set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	
End Sub

Public Function CreateLocalIsolatedFTP(strPath,StrFTPSite)
'===================================================
'	NAME:	CreateIsolatedFTP
'	IN:		StrPath - Path to the WebContent Root
'			srFTPSite - Name of FTP Site
'	COMMENT: Uses IISFtp.vbs to Create an Isolated FTP site
'===================================================
	Dim strCmd
	Dim oExec
	Dim oWMI
	Dim oFTPSite
	Dim oFTPSvc
	Dim oSite
	Dim oSiteProps
	'Create the commandline 
	strCmd = "cmd.exe /C cscript //nologo %systemroot%\system32\IIsFtp.vbs /Create " & strPath & " " & strFTPSite & " /b 21 /isolation:Local"
	'execute it
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	
	'Set the FTP site for Read/write access
	'fetch a reference to the FTP Service using ADSI
	Set oFTPSvc = GetObject("IIS://localhost/msftpsvc")
	' Enumerate all FTP Sites on the Box to find IsolatedFTP
	For Each oSite In oFTPSvc
	' if this is a FTPServer Object continue
		if oSite.class = "IIsFtpServer" Then
			If oSite.ServerComment = strFTPSite then 
				Write oLogFile,"Setting Properties on " & oSite.AdsPath,Err_INFO,bDebug
				' Bind to the Root Object of the FTP Server And
				' set the properties
				Set oSiteProps = GetObject(oSite.AdsPath & "/root")
				oSiteProps.AccessRead = True
				oSiteProps.AccessWrite = True
				' Commit Changes
				oSiteProps.Setinfo
			End If
		end If
	Next
	CreateLocalIsolatedFTP="Create IsolatedFTP"
End Function
Public Function CreateADIsolatedFTP(strPath,StrFTPSite,strDomain,strUser,strPassword)
'===================================================
'	NAME:	CreateADIsolatedFTP
'	IN:		StrPath - Path to the WebContent Root
'			srFTPSite - Name of FTP Site
'			strDomain - AD Domain
'			strUser - FTP User
'			strPAssword - Password of the FTP User account
'	COMMENT: Uses IISFtp.vbs to Create an Isolated FTP site
'===================================================
	Dim strCmd
	Dim oExec
	Dim oWMI
	Dim oFTPSite
	Dim oFTPSvc
	Dim oSite
	Dim oSiteProps
	'Create the commandline 
	strCmd = "cmd.exe /C cscript //nologo %systemroot%\system32\IIsFtp.vbs /Create " & strPath & " " & strFTPSite & " /b 21 /isolation:AD /ADdomain:" & strDomain & " /ADadmin:" & strDomain & "\" & strUser & " /ADpass:" & strPassword
	WScript.Echo strCmd
	
	'execute it
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	
	'Set the FTP site for Read/write access
	'fetch a reference to the FTP Service using ADSI
	Set oFTPSvc = GetObject("IIS://localhost/msftpsvc")
	' Enumerate all FTP Sites on the Box to find IsolatedFTP
	For Each oSite In oFTPSvc
	' if this is a FTPServer Object continue
		if oSite.class = "IIsFtpServer" Then
			If oSite.ServerComment = strFTPSite then 
				Write oLogFile,"Setting Properties on " & oSite.AdsPath,Err_INFO,bDebug
				' Bind to the Root Object of the FTP Server And
				' set the properties
				Set oSiteProps = GetObject(oSite.AdsPath & "/root")
				oSiteProps.AccessRead = True
				oSiteProps.AccessWrite = True
				' Commit Changes
				oSiteProps.Setinfo
			End If
		end If
	Next
	CreateADIsolatedFTP="Created IsolatedFTP."
	
End Function
Public Function ChangeDefaultASPNET()
'===================================================
'	NAME:	ChangeDefaultASPNET
'	IN:		None
'	COMMENT: Enables ASP.Net 2.0 in the IIS Mgr and 
'			changes all scrpt mappings to default to 2.0
'===================================================
	Dim oExec
	Dim strCmd
	
	strCmd = "cmd.exe /C %windir%\microsoft.NET\Framework\v2.0.50727\aspnet_regiis.exe -r -enable"
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop



End Function

Public Sub RecycleIIS()
'===================================================
'	NAME:	RecycleIIS
'	IN:		None
'	COMMENT: recycles IIS to update bindings
'===================================================
	Dim strCmd
	Dim oExec
	
	strCmd = "cmd.exe /C iisreset /restart"
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop

End Sub

Public Sub ConfigFPSE()
'===================================================
'	NAME:	ConfigFPSE
'	IN:		None
'	COMMENT: Creates FPSE registry keys for various settings
'===================================================
	Dim strCmd
	Dim oExec
	strCmd = "cmd.exe /C regedit.exe /s fpsesettings.reg"
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	


End Sub




